CON

  _CLKMODE = XTAL1 + PLL16X
  _XINFREQ = 5_000_000



Enable = 26
Detect = 25
Laser = 24

Button = 21
Up = 20
Down = 19
Left = 18
Right = 17

HomeX = 23

Acceltop = 5000
SpeedBotX = 10000
SpeedBotY = 10000

MemStart = 32_768                  'Start of routine memory
MemEnd = 65_534 

SampleRate = 4_000_000

VAR

  byte PhaseX                   'Location of step information
  byte PhaseY
  word Accel                    'Accelleration
  long AccelCount

  byte WriteByte
  byte ReadByte

  word MemLoc                   'Where we are at in program or reading

OBJ

    e : "I2C_driver" 

PUB Main

dira[6..13]~~

dira[HomeX]~                    'Homing switch
dira[Enable]~~
dira[Detect]~
dira[Laser]~~

dira[17..21]~

PhaseX := 1                      'Starting position
PhaseY := 1                      'Starting position

LaserOff

repeat

  if ina[Detect] == 1                                   'Motion sensed? 
    Home
    Routine
    waitcnt(320_000_000 + cnt)
    repeat while ina[Detect]                            'Wait for no motion

  if ina[Button] == 0                                   'Trigger pressed?
    Home  
    repeat while ina[Button] == 0                       'Wait for release
    'Routine
    Program



PUB Home

StepperOn    

repeat

  if ina[HomeX] == 1

    quit

  CCW("X", 10000)

waitcnt(40_000_000 + cnt)

repeat 27

  CW("X", 15000)

StepperOff 


PUB Program | Time 

waitcnt(20_000_000 + cnt)

MemLoc := MemStart

e.Initialize(28)                                    'High Score Module

Time := cnt                     'Get current system counter value

LaserOn
StepperOn

repeat while ina[Button]        'Do this until button pressed again

  WriteByte := 0                'Clear byte

  if ina[17..20] == %1111       'Nothing pushed?
    if Accel
      Accel -= 1
    
  if ina[Up] == 0
    CCW("Y", SpeedBotY - Accel)
    Accel += 1
         
  if ina[Down] == 0
    CW("Y", SpeedBotY - Accel)
    Accel += 1
              
  if ina[Left] == 0
    CCW("X", SpeedBotX - Accel)
    Accel += 1
        
  if ina[Right] == 0
    CW("X", SpeedBotX - Accel)   
    Accel += 1

  if Accel > AccelTop
    Accel := AccelTop

  WriteByte := ina[17..20]

  waitcnt(Time += SampleRate) 

  if ina[17..20] == %1111       'Nothing pushed?
    if Accel
      Accel -= 1
    
  if ina[Up] == 0
    CCW("Y", SpeedBotY - Accel)
    Accel += 1
         
  if ina[Down] == 0
    CW("Y", SpeedBotY - Accel)
    Accel += 1
              
  if ina[Left] == 0
    CCW("X", SpeedBotX - Accel)
    Accel += 1
        
  if ina[Right] == 0
    CW("X", SpeedBotX - Accel)   
    Accel += 1

  if Accel > AccelTop
    Accel := AccelTop

  WriteByte <<= 4              'Shift it over
  WriteByte |= ina[17..20]     'Add in new bits

  e.WriteByte(28, $A0, MemLoc, WriteByte)               'Write 2 frames of data    

  MemLoc += 1                                           'Advance counter
  
  if MemLoc == MemEnd                                   'Did we somehow spend 30 minutes doing this?
    quit                                                'We're done here!
  
  waitcnt(Time += SampleRate) 

e.WriteByte(28, $A0, MemLoc, 0)                         'EOF   
e.Stop(28)

LaserOff
StepperOff

waitcnt(20_000_000 + cnt)  


PUB Routine | BitLob, Time

LaserOn
StepperOn

MemLoc := MemStart

e.Initialize(28)

Time := cnt                     'Get current system counter value   

repeat

  ReadByte := e.ReadLong(28, $A0, MemLoc)               'Get 2 frames of data

  if ReadByte == 0                                      'EOF?
    quit

  MemLoc += 1

  BitLob := ReadByte

  BitLob >>= 4                                        'MSB's are Frame 0

  if BitLob == %0000_1111       'Nothing pushed?
    if Accel
      Accel -= 1
    
  if (BitLob & %0000_0001) == 0
    CCW("Y", SpeedBotY - Accel)
    Accel += 1
         
  if (BitLob & %0000_0010) == 0
    CW("Y", SpeedBotY - Accel)
    Accel += 1
              
  if (BitLob & %0000_0100) == 0
    CCW("X", SpeedBotX - Accel)
    Accel += 1
        
  if (BitLob & %0000_1000) == 0
    CW("X", SpeedBotX - Accel)   
    Accel += 1

  if Accel > AccelTop
    Accel := AccelTop

  waitcnt(Time += SampleRate) 

  BitLob := ReadByte

  BitLob &= %0000_1111          'LSB's are Frame 0

  if BitLob == %0000_1111       'Nothing pushed?
    if Accel
      Accel -= 1
    
  if (BitLob & %0000_0001) == 0
    CCW("Y", SpeedBotY - Accel)
    Accel += 1
         
  if (BitLob & %0000_0010) == 0
    CW("Y", SpeedBotY - Accel)
    Accel += 1
              
  if (BitLob & %0000_0100) == 0
    CCW("X", SpeedBotX - Accel)
    Accel += 1
        
  if (BitLob & %0000_1000) == 0
    CW("X", SpeedBotX - Accel)   
    Accel += 1

  if Accel > AccelTop
    Accel := AccelTop  

  waitcnt(Time += SampleRate)

e.Stop(28)

LaserOff
StepperOff

waitcnt(20_000_000 + cnt)  
  

PUB CW(motor, speed)

if motor == 88

  PhaseX += 1
  if PhaseX > 4
    PhaseX := 1
    
  outa[6..9] := byte[@Stepper][PhaseX]
  Wait(speed)



if motor == 89

  PhaseY += 1
  if PhaseY > 4
    PhaseY := 1 

  outa[10..13] := byte[@Stepper][PhaseY]
  Wait(speed)



PUB CCW(motor, speed)

if motor == 88

  PhaseX -= 1
  if PhaseX < 1
    PhaseX := 4  

  outa[6..9] := byte[@Stepper][PhaseX]
  Wait(speed)

               

if motor == 89

  PhaseY -= 1
  if PhaseY < 1
    PhaseY := 4
    
  outa[10..13] := byte[@Stepper][PhaseY]
  Wait(speed)



PUB Wait(speed)

waitcnt((speed * 100) + cnt)


PUB LaserOn

outa[Laser]~                 'On


PUB LaserOff

outa[Laser]~~                 'On

PUB StepperOn

outa[Enable]~~

PUB StepperOff

outa[Enable]~

DAT


STEPPER

        byte %1001
        
        byte %0101
        byte %0110
        byte %1010
        byte %1001
        
        byte %0101 
   